#pragma rtGlobals=1		// Use modern global access method.
#pragma version=3.1

// ******** MPR Hilbert *******

Function MPRHilbertReset()
	MPRHilbertSetupDesign()
	SetAxis/A/Z bottom			// in case user set a manual X axis range
	Execute "mhComputeButton(\"\")"
End

Function ButtonMPRHilbert(ctrlName) : ButtonControl
	String ctrlName

	DoWindow/F WMMPRHilbertDesign
	if( V_Flag==0 )
		MPRHilbertSetupDesign()
	endif
End

Function MPRHilbertSetupDesign()
	SetApplyButtonTitle(0)

	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	Variable nt=NumVarOrDefault("mh_n",11)
	Variable fLow=NumVarOrDefault("mh_fl",0.05)
	Variable fHigh=NumVarOrDefault("mh_fh",0.45)

	// Create the globals
	Variable/G mh_n=nt
	Variable/G mh_fl=fLow
	Variable/G mh_fh=fHigh

	// scale the saved normalized frequencies for the SetVariable controls
	Variable/G mh_fl_fs= mh_fl * fs
	Variable/G mh_fh_fs= mh_fh * fs

	Variable/G mh_lastChanged= 0	// saves which SetVariable control was last updated
	
	SetDataFolder dfSav

	MPRHilbertUpdate()
	CreateMPRHilbertDesign()
	MPRHilbertUpdate()			// set the control limits, too.
End

Function MPRHilbertUpdate()

	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	Variable nt= NumVarOrDefault("mh_n",11)
	Variable fLowFs= NumVarOrDefault("mh_fl_fs",0.05 * fs)	// mh_fl_fs is updated by the SetVariable control
	Variable fHighFs=NumVarOrDefault("mh_fh_fs",0.45 * fs)

	// keep mh_n odd
	Variable/G mh_n = round(nt) %| 1
	
	Variable lowChanged= NumVarOrDefault("mh_fl",fLowFs/fs) != fLowFs/fs
	Variable highChanged= NumVarOrDefault("mh_fh",fHighFs/fs) != fHighFs/fs
	
	// keep the values symmetrical
	DoWindow WMMPRHilbertDesign
	Variable haveGraph= V_Flag
	Variable symmetrical= 0
	if( haveGraph )
		ControlInfo/W=WMMPRHilbertDesign symCheck
		symmetrical= V_Value
		if( symmetrical )
			// keep frequencies valid
			fLowFs = limit(fLowFs,0,fs/4)
			fHighFs = limit(fHighFs,fs/4,fs/2)

			// Check which value(s) changed (just now or most recently)
			Variable changeLow= lowChanged %| ( !highChanged %& (NumVarOrDefault("mh_lastChanged",0) == 1) )
			if( changeLow )
				fHighFs = fs/2 - fLowFs		// modify the high value to match
			else
				fLowFs = fs/2 - fHighFs		// modify the low value to match
			endif
			Variable/G mh_fl_fs= fLowFs
			ControlUpdate/W=WMMPRHilbertDesign mh_fLow
			Variable/G mh_fh_fs= fHighFs
			ControlUpdate/W=WMMPRHilbertDesign mh_fHigh
		endif	
	endif

	// Save the normalized frequencies in case the user changes sampling frequency
	// and remember the previous values
	Variable/G mh_fl= fLowFs/fs
	Variable/G mh_fh= fHighFs/fs
	if( lowChanged )
		Variable/G mh_lastChanged= 1
	endif
	if( highChanged )
		Variable/G mh_lastChanged= 2
	endif

	// Passband and stop band response pair, linear or dB response
	Variable transMax= 1
	Make/O mh_responseX = {0,fLowFs,fLowFs,fHighFs,fHighFs,fs*0.5}
	Make/O mh_response  = {1e-6,1e-6,1,1,1e-6,1e-6}	// converted to dB if dB Response is checked

	Wave filterResult= root:Packages:WM_IFDL:coefsMag

	if( haveGraph )
		CheckDisplayed/W=WMMPRHilbertDesign filterResult
		if( V_Flag == 1 )
			transMax= MaximumInBand(filterResult,0,fs/2)
		endif
		ControlInfo/W=WMMPRHilbertDesign dbCheck
		if( V_Value ) 	// want DB
			transMax= 0
			mh_response= 20*log(mh_response)
		endif
	endif
	
	// transition region waves
	Make/O          mh_transitionX = {mh_responseX[0],mh_responseX[1],NaN,mh_responseX[4],mh_responseX[5]}
	Make/O/N=5 mh_transitionPlus =  transMax;               mh_transitionPlus[2]= NaN
	Make/O/N=5 mh_transitionMinus = mh_response[0]; mh_transitionMinus[2]= NaN

	if( haveGraph) // don't allow the end of the pass band to exceed the start of the stop band
		ControlInfo/W=WMMPRHilbertDesign mh_fLow
		Variable lowFs= V_Value
		ControlInfo/W=WMMPRHilbertDesign mh_fHigh
		Variable highFs= V_Value
		
		Variable df=  NiceNumber(fs/200)

		// don't let band 1 end after the start of band 2
		Variable lowMax= max(lowFs,highFs)
		if( symmetrical )
			lowMax= limit(lowMax,0,fs/4)
		else
			lowMax= limit(lowMax,0,fs/2)
		endif
		SetVariable mh_fLow,limits={0,lowMax,df},win=WMMPRHilbertDesign
		
		// don't let band 2 start before the end of band 1
		Variable highMin= min(lowFs,highFs)
		if( symmetrical )
			highMin= limit(highMin,fs/4, fs/2)
		else
			highMin= limit(highMin,0, fs/2)
		endif
		SetVariable mh_fHigh,limits={highMin,fs/2,df},win=WMMPRHilbertDesign
	endif
	SetDataFolder dfSav
End

Function CreateMPRHilbertDesign()

	if( DesignGraph("WMMPRHilbertDesign","MPR Hilbert Design") )
		return 1	// already existed, don't reset the graph settings.
	endif

	NVAR fs= root:Packages:WM_IFDL:fs
	Variable df= NiceNumber(fs/200)	// 1,2,5 increment for SetVariable controls

	String dfSav= Set_IFDL_DataFolder()
	AppendToGraph/L=responseLeft mh_transitionPlus,mh_transitionMinus vs mh_transitionX
	AppendToGraph/L=responseLeft mh_response vs mh_responseX
	SetDataFolder dfSav

	ModifyGraph mode(mh_transitionPlus)=7
	ModifyGraph lSize(mh_transitionPlus)=0,lSize(mh_transitionMinus)=0
	ModifyGraph rgb(mh_transitionPlus)=(56797,56797,56797)
	ModifyGraph hbFill(mh_transitionPlus)=2
	ModifyGraph toMode(mh_transitionPlus)=1

	ModifyGraph lblPos(responseLeft)=60
	ModifyGraph freePos(responseLeft)={0,bottom}
	ModifyGraph margin(left)=67
	ModifyGraph minor(bottom)=1
	SetAxis/A/N=1 responseLeft
	Label responseLeft, "response (dB)"
	ControlBar 44
	SetVariable mh_fLow,pos={4,3},size={232,17},proc=MPR_mh,title="Start of Pass Band"
	SetVariable mh_fLow,limits={0,fs/2,df},value= root:Packages:WM_IFDL:mh_fl_fs
	SetVariable mh_fHigh,pos={16,23},size={220,17},proc=MPR_mh,title="End of Pass Band"
	SetVariable mh_fHigh,limits={0,fs/2,df},value= root:Packages:WM_IFDL:mh_fh_fs
	SetVariable mh_n,pos={369,3},size={109,17},proc=MPR_mh,title="Terms"
	SetVariable mh_n,limits={5,9999,2},value= root:Packages:WM_IFDL:mh_n
	CheckBox symCheck,pos={244,4},size={113,15},proc=mhSymCheck,title="Symmetrical",value=1
	CheckBox dbCheck,pos={244,24},size={110,15},proc=mhCheck,title="dB Response",value=1
	Button mhCompute,pos={370,23},size={109,18},proc=mhComputeButton,title="Compute Filter"

	Textbox/C/N=mhLegend/A=MC/X=0/Y=-20 ""
	mhLegend()
	SetWindow WMMPRHilbertDesign, hook=designHook
	return 0
End

Function MPR_mh(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName

	MPRHilbertUpdate()
End

Function mhCheck(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
 	
 	dBCheck(checked)
	MPRHilbertUpdate()
	mhLegend()
End

Function mhSymCheck(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
 	
	MPRHilbertUpdate()
End

Function mhLegend()
	DesignLegend("WMMPRHilbertDesign","mh","mhLegend")
End

Proc mhComputeButton(ctrlName) : ButtonControl
	String ctrlName

	Silent 1;PauseUpdate	 // MPR Hilbert...
	String dfSav= Set_IFDL_DataFolder()
	Variable nt= mh_n
	Variable fLow= mh_fl
	Variable fHigh=mh_fh
	SetDataFolder dfSav
	Variable fs = root:Packages:WM_IFDL:fs
	
	if( nt > 9999 )
		Abort "Too many filter terms. Max is 9999."
	endif 
	if( ChkFreq(fLow,fHigh,0,0) )
		abort
	endif

	Set_IFDL_DataFolder()
	String/G proposedFilterName="mprHilbert"
	String/G designTypeName="McClellan-Parks; Hilbert transformer"
	Variable/G designFlags=0x3
	Make/O bandInfo= {1,fLow*fs,fHigh*fs}

	String mpDes="des"
	String mpWt="wt"
	String mpGrid="grid"
	MPRMakeWaves(mpDes,mpWt,mpGrid,nt)
	$mpDes=0
	$mpDes(fLow,fHigh)=1
	$mpGrid(0,fLow)=NaN
	$mpGrid(fHigh,)=NaN
	
	SetDataFolder dfSav
	Make/O/N=(nt) coefs
	
	MPKernel(mpDes,mpWt,mpGrid,"coefs",1)
	if(nt%&1)
		coefs[floor(nt/2)]=0
	endif
	
	StdCoefsTreatmentNoShowResults(0x1e,1)

	DoWindow/F WMMPRHilbertDesign
	CheckDisplayed/W=WMMPRHilbertDesign root:Packages:WM_IFDL:coefsMag,root:Packages:WM_IFDL:coefsDbMag
	if( V_Flag == 0 )
		ControlInfo/W=WMMPRHilbertDesign dbCheck
		Variable wantDB= V_value
		AppendToGraph/L=responseLeft $responseName(wantDB,1)
		String traceName= responseName(wantDB,0)
		ModifyGraph rgb($traceName)=(0,0,65535)
		ReorderTraces mh_response, {$traceName}	// put actual response under desired response
	endif
	AppendPassDetails("detailsLeft",root:Packages:WM_IFDL:magPassDetails)

	// put phase on RHS of "detailsLeft" axis, 
	CheckDisplayed/W=WMMPRHilbertDesign root:Packages:WM_IFDL:phasePassDetails
	if( V_Flag == 0 )
		AppendToGraph/R=phase root:Packages:WM_IFDL:phasePassDetails
		ModifyGraph  lstyle(phasePassDetails)= 1
		// Set trace and axis to red (65535,0,0)
		ModifyGraph rgb(phasePassDetails)=(65535,0,0), axRGB(phase)=(65535,0,0)
		ModifyGraph tlblRGB(phase)=(65535,0,0),  alblRGB(phase)=(65535,0,0)
		// Make the phase axis just as tall as the detailsLeft axis
		Variable/C axlowHi= mh_AxisFractionsC("WMMPRHilbertDesign","detailsLeft")
		ModifyGraph axisEnab(phase)={real(axlowHi),imag(axlowHi)},  freePos(phase)=0,  lblPos(phase)=89
		// make room for phase axis labels
		ModifyGraph margin(right)=93	
		Label phase "phase (deg)"
		ModifyGraph nticks(phase)=2
		SetAxis/A/N=1 phase
	endif
	MPRHilbertUpdate()
	AutoApplyFilter()
	mhLegend()
end

// returns low fraction in real part
// returns high fraction in imaginary part
Function/C  mh_AxisFractionsC(graphName,axName)
	String graphName,axName
	
	String info= AxisInfo(graphName,axName)
	
	Variable lowFrac=  GetNumFromModifyStr(info,"axisEnab","{",0)
	Variable highFrac=  GetNumFromModifyStr(info,"axisEnab","{",1)
	
	return cmplx(lowFrac,highFrac)
End